/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_multicostregular.example;

import choco.cp.solver.search.integer.varselector.StaticVarOrder;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.memory.IStateInt;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.search.AbstractSearchHeuristic;
import choco.kernel.solver.search.ValSelector;
import choco.kernel.solver.search.integer.AbstractIntVarSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class CoverVarValSelector
extends AbstractSearchHeuristic
implements VarSelector<IntDomainVar>,
ValSelector<IntDomainVar> {
    AbstractIntVarSelector other;
    IntDomainVar[][] vars;
    IntDomainVar selected;
    int nVal;
    IStateInt lastCol;
    int[][] lowb;

    public CoverVarValSelector(IntDomainVar[][] vars, int[][] lowb, Solver solver) {
        super(solver);
        this.vars = vars;
        this.lowb = lowb;
        this.other = new StaticVarOrder(solver, ArrayUtils.flatten(vars));
        this.lastCol = solver.getEnvironment().makeInt(0);
    }

    public CoverVarValSelector(Solver s, IntegerVariable[][] mvars, int[][] lowb) {
        super(s);
        IntegerVariable[][] tmp = ArrayUtils.transpose(mvars);
        this.vars = new IntDomainVar[tmp.length][];
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i] = s.getVar(tmp[i]);
        }
        this.lowb = lowb;
        this.other = new StaticVarOrder(s, ArrayUtils.flatten(this.vars));
        this.lastCol = s.getEnvironment().makeInt(0);
    }

    private int scanCol(int idx) {
        int[] tmp = new int[this.lowb[idx].length];
        IntDomainVar[] col = this.vars[idx];
        int[] low = this.lowb[idx];
        for (IntDomainVar v : col) {
            if (!v.isInstantiated()) continue;
            int n = v.getVal();
            tmp[n] = tmp[n] + 1;
        }
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] >= low[i]) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private IntDomainVar getFirstVar(int idx) {
        for (IntDomainVar v : this.vars[idx]) {
            if (v.isInstantiated()) continue;
            return v;
        }
        return null;
    }

    @Override
    public IntDomainVar selectVar() {
        int tmp = 0;
        while (this.lastCol.get() < this.vars.length && (tmp = this.scanCol(this.lastCol.get())) == Integer.MAX_VALUE) {
            this.lastCol.add(1);
        }
        if (this.lastCol.get() == this.vars.length) {
            this.selected = (IntDomainVar)this.other.selectVar();
            this.nVal = this.selected == null ? 0 : this.selected.getSup();
        } else {
            this.selected = this.getFirstVar(this.lastCol.get());
            this.nVal = tmp;
        }
        return this.selected;
    }

    @Override
    public int getBestVal(IntDomainVar x) {
        if (x == this.selected && x.canBeInstantiatedTo(this.nVal)) {
            return this.nVal;
        }
        return x.getSup();
    }
}

