/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.graph;

import choco.cp.common.util.preprocessor.graph.ArrayGraph;
import choco.kernel.common.logging.ChocoLogging;
import java.util.Random;
import java.util.logging.Logger;

public final class MaxCliques {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private final ArrayGraph graph;
    private int[][] cliques;

    public MaxCliques(ArrayGraph g) {
        this.graph = g;
        this.computeCliques();
    }

    public void computeCliques() {
        this.graph.setNeighbours();
        boolean[] cand = new boolean[this.graph.nbNode];
        boolean[] K = new boolean[this.graph.nbNode];
        boolean[] gammaK = new boolean[this.graph.nbNode];
        int[] degrees = this.graph.degrees();
        boolean empty = true;
        for (int i = 0; i < this.graph.nbNode; ++i) {
            if (degrees[i] <= 0) continue;
            empty = false;
            cand[i] = true;
            K[i] = false;
            gammaK[i] = true;
        }
        this.cliques = new int[0][0];
        if (!empty) {
            this.BronKerbosh(cand, K, gammaK);
        }
    }

    private boolean BronKerbosh(boolean[] cand, boolean[] K, boolean[] gammaK) {
        boolean b;
        int x = this.getAndRemoveMaxCand(cand);
        boolean[] updatedCand = this.removeNeighbours(x, cand);
        if (!MaxCliques.empty(updatedCand) && !(b = this.BronKerbosh(updatedCand, (boolean[])K.clone(), (boolean[])gammaK.clone()))) {
            return false;
        }
        K[x] = true;
        boolean[] updatedGammaK = this.updateGammaK(x, gammaK);
        if (!MaxCliques.empty(updatedGammaK)) {
            return this.BronKerbosh(updatedGammaK, K, updatedGammaK);
        }
        this.cliques = this.storeCliques(K);
        return this.cliques.length <= 2000;
    }

    private static boolean empty(boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            return false;
        }
        return true;
    }

    private int getAndRemoveMaxCand(boolean[] cand) {
        int index = -1;
        if (!MaxCliques.empty(cand)) {
            int max = 0;
            int[] degrees = this.graph.degrees();
            for (int i = 0; i < cand.length; ++i) {
                if (degrees[i] <= max || !cand[i]) continue;
                max = degrees[i];
                index = i;
            }
            cand[index] = false;
        }
        return index;
    }

    private boolean[] removeNeighbours(int x, boolean[] cand) {
        boolean[] res = (boolean[])cand.clone();
        int[] neighbours = this.graph.neighbours(x);
        for (int i = 0; i < neighbours.length; ++i) {
            res[neighbours[i]] = false;
        }
        return res;
    }

    private boolean[] updateGammaK(int x, boolean[] gammaK) {
        boolean[] res = (boolean[])gammaK.clone();
        for (int i = 0; i < gammaK.length; ++i) {
            boolean isIn;
            if (!res[i] || (isIn = this.graph.isIn(x, i))) continue;
            res[i] = false;
        }
        res[x] = false;
        return res;
    }

    private int[][] storeCliques(boolean[] K) {
        int[][] updated = new int[this.cliques.length + 1][];
        System.arraycopy(this.cliques, 0, updated, 0, updated.length - 1);
        int size = 0;
        for (int i = 0; i < K.length; ++i) {
            if (!K[i]) continue;
            ++size;
        }
        updated[updated.length - 1] = new int[size];
        int index = 0;
        for (int i = 0; i < K.length; ++i) {
            if (!K[i]) continue;
            updated[updated.length - 1][index] = i;
            ++index;
        }
        return updated;
    }

    public int[][] getMaxCliques() {
        return this.cliques;
    }

    public static String display(int[] array) {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            s.append(array[i]);
            if (i >= array.length - 1) continue;
            s.append(',');
        }
        s.append(']');
        return s.toString();
    }

    public static String display(int[][] array) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            s.append(MaxCliques.display(array[i]));
            s.append('\n');
        }
        return s.toString();
    }

    public static ArrayGraph generateGraph(int n, int m, int seed, double start) {
        LOGGER.info("Generating graph... ");
        ArrayGraph g = new ArrayGraph(n);
        if (m > n * (n + 1) / 2) {
            m = n * (n + 1) / 2;
        }
        Random r = new Random(seed);
        int nbNode = g.nbNode;
        for (int i = 0; i < m; ++i) {
            int v1 = Math.abs(r.nextInt()) % nbNode;
            int v2 = Math.abs(r.nextInt()) % nbNode;
            while (v1 == v2 || g.isIn(v1, v2)) {
                v1 = Math.abs(r.nextInt()) % nbNode;
                v2 = Math.abs(r.nextInt()) % nbNode;
            }
            g.addEdge(v1, v2);
        }
        LOGGER.info("done (" + ((double)System.currentTimeMillis() - start) + " ms).\n");
        return g;
    }
}

