% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_area}
\alias{turf_area}
\title{Calculate area of geometries}
\usage{
turf_area(proxy, layer_id = NULL, data = NULL, input_id = "turf_area_result")
}
\arguments{
\item{proxy}{A mapboxgl_proxy or maplibre_proxy object.}

\item{layer_id}{The ID of the layer or source containing the polygons (mutually exclusive with data).}

\item{data}{An sf object containing polygons (mutually exclusive with layer_id).}

\item{input_id}{Character string specifying the Shiny input ID suffix for storing the area result. Default is "turf_area_result". Result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The proxy object for method chaining.
}
\description{
This function calculates the area of polygons in a layer or sf object.
Note: This function only works with proxy objects as it returns a numeric value to R.
}
