% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_grid_ESDAC.R
\name{esp_get_grid_ESDAC}
\alias{esp_get_grid_ESDAC}
\title{Get \CRANpkg{sf} polygons of the national geographic grids provided by ESDAC}
\source{
\href{https://esdac.jrc.ec.europa.eu/content/european-reference-grids}{EEA reference grid}.
}
\usage{
esp_get_grid_ESDAC(
  resolution = 10,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{resolution}{Resolution of the grid in kms. Could be \code{1} or \code{10}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \CRANpkg{sf} polygon
}
\description{
Loads a \CRANpkg{sf} polygon with the geographic grids of Spain as provided
by the European Soil Data Centre (ESDAC).
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\dontshow{if (esp_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
grid <- esp_get_grid_ESDAC()
esp <- esp_get_country(moveCAN = FALSE)

library(ggplot2)

ggplot(grid) +
  geom_sf() +
  geom_sf(data = esp, color = "grey50", fill = NA) +
  theme_light() +
  labs(title = "ESDAC Grid for Spain")
}
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Panagos P., Van Liedekerke M., Jones A., Montanarella L., "European Soil
Data Centre: Response to European policy support and public data
requirements"; (2012) \emph{Land Use Policy}, 29 (2), pp. 329-338.
\doi{10.1016/j.landusepol.2011.07.003}
\item European Soil Data Centre (ESDAC), esdac.jrc.ec.europa.eu, European
Commission, Joint Research Centre.
}
}
\seealso{
Other grids: 
\code{\link{esp_get_grid_BDN}()},
\code{\link{esp_get_grid_EEA}()},
\code{\link{esp_get_grid_MTN}()}
}
\concept{grids}
