% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/HSManifold.R,
%   R/SOManifold.R, R/SPDManifolds.R, R/SphereManifold.R
\name{metric.Euclidean}
\alias{metric.Euclidean}
\alias{metric}
\alias{metric.default}
\alias{metric.HS}
\alias{metric.Dens}
\alias{metric.SO}
\alias{metric.LogEu}
\alias{metric.AffInv}
\alias{metric.Sphere}
\title{Returns the Riemannian metric}
\usage{
\method{metric}{Euclidean}(mfd, p, U, V)

metric(mfd, p, U, V)

\method{metric}{default}(mfd, p = NULL, U, V)

\method{metric}{HS}(mfd, p, U, V)

\method{metric}{Dens}(mfd, p, U, V)

\method{metric}{SO}(mfd, p, U, V)

\method{metric}{LogEu}(mfd, p, U, V)

\method{metric}{AffInv}(mfd, p, U, V)

\method{metric}{Sphere}(mfd, p, U, V)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{p}{A vector containing the (single) base point on the manifold.}

\item{U, V}{Matrices with n columns each containing a tangent vector. The metric of each pair of n columns is calculated.}
}
\value{
A vector with n entries containing the metric values
}
\description{
Returns the Riemannian metric
}
\section{Methods (by class)}{
\itemize{
\item \code{metric(Euclidean)}: Method

\item \code{metric(default)}: Method

\item \code{metric(HS)}: Method

\item \code{metric(Dens)}: Method

\item \code{metric(SO)}: Method

\item \code{metric(LogEu)}: Method

\item \code{metric(AffInv)}: Method

\item \code{metric(Sphere)}: Method

}}
