% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pedigrees_all_populate_haplotypes_custom_founders}
\alias{pedigrees_all_populate_haplotypes_custom_founders}
\title{Populate haplotypes in pedigrees (custom founder/unbounded).}
\usage{
pedigrees_all_populate_haplotypes_custom_founders(
  pedigrees,
  mutation_rates,
  get_founder_haplotype = NULL,
  prob_two_step = 0,
  prob_genealogical_error = 0,
  progress = TRUE
)
}
\arguments{
\item{pedigrees}{Pedigree list in which to populate haplotypes}

\item{mutation_rates}{Vector with mutation rates}

\item{get_founder_haplotype}{Function taking no arguments returning a haplotype of \code{length(mutation_rates)}}

\item{prob_two_step}{Given a mutation happens, this is the probability that the mutation is a two-step mutation}

\item{prob_genealogical_error}{Probability that a genealogical error happens: if so, give individual haplotype \code{get_founder_haplotype()} instead of father's}

\item{progress}{Show progress}
}
\description{
Populate haplotypes from founder and down in all pedigrees.
Note, that haplotypes are unbounded.
All founders get a haplotype from calling the user
provided function \code{get_founder_haplotype()}.
}
\details{
Note, that pedigrees must first have been inferred by \code{\link[=build_pedigrees]{build_pedigrees()}}.
}
\examples{
sim <- sample_geneology(100, 10)
peds <- build_pedigrees(sim$population)
pedigrees_all_populate_haplotypes_custom_founders(
  peds, c(1, 1), function(x) c(10, 10))
get_haplotype(sim$end_generation_individuals[[1]])

}
\seealso{
\code{\link[=pedigrees_all_populate_haplotypes]{pedigrees_all_populate_haplotypes()}} and
\code{\link[=pedigrees_all_populate_haplotypes_ladder_bounded]{pedigrees_all_populate_haplotypes_ladder_bounded()}}.
}
