% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{estimate_autotheta_subpops_unweighted_pids}
\alias{estimate_autotheta_subpops_unweighted_pids}
\title{Unweighted estimate of autosomal theta from subpopulations of individual ids}
\usage{
estimate_autotheta_subpops_unweighted_pids(population, subpops, assume_HWE)
}
\arguments{
\item{population}{Population obtain from simulation}

\item{subpops}{List of individual pids}

\item{assume_HWE}{if the alleles themselves are used instead of genotypes}
}
\value{
Estimate of autosomal theta
}
\description{
Estimates unweighted autosomal theta for a number of subpopulations given a list of pids (individual ids).
}
\details{
Assumes that \code{\link[=pedigrees_all_populate_autosomal]{pedigrees_all_populate_autosomal()}} was used first to populate autosomal genotypes.

Based on Weir and Goudet, Genetics 2017:
http://www.genetics.org/content/early/2017/05/26/genetics.116.198424
}
