% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/det.r
\docType{methods}
\name{det}
\alias{det}
\alias{determinant.madness}
\alias{determinant,madness,ANY-method}
\alias{determinant}
\alias{determinant,madness,missing-method}
\alias{determinant,madness,logical-method}
\title{Matrix Determinant}
\usage{
\method{determinant}{madness}(x, logarithm = TRUE, ...)

det(x, ...)

\S4method{determinant}{madness,ANY}(x, logarithm = TRUE, ...)

\S4method{determinant}{madness,missing}(x, logarithm = TRUE, ...)

\S4method{determinant}{madness,logical}(x, logarithm = TRUE, ...)
}
\arguments{
\item{x}{\code{madness} object.}

\item{logarithm}{logical; if \code{TRUE} (default) return the
    logarithm of the modulus of the determinant.}

\item{...}{Optional arguments.  At present none are used.  Previous
    versions of \code{det} allowed an optional \code{method} argument.
    This argument will be ignored but will not produce an error.}
}
\value{
a list with elements \code{modulus} and \code{sign}, 
which are \code{madness} objects.
}
\description{
Compute the determinant of a matrix. As for \code{base::determinant},
a list of the modulus and sign are returned.
}
\note{
throws an error for non-square matrices or non-matrix input.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
