% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/as.data.frame.R
\docType{methods}
\name{as.data.frame.ExpVarRasterList}
\alias{as.data.frame,ExpVarRasterList-method}
\alias{as.data.frame,ObsLulcRasterStack-method}
\alias{as.data.frame.ExpVarRasterList}
\alias{as.data.frame.ObsLulcRasterStack}
\title{Coerce objects to data.frame}
\usage{
\method{as.data.frame}{ExpVarRasterList}(x, row.names = NULL,
  optional = FALSE, cells, t = 0, ...)

\method{as.data.frame}{ObsLulcRasterStack}(x, row.names = NULL,
  optional = FALSE, cells, t = 0, ...)

\S4method{as.data.frame}{ExpVarRasterList}(x, row.names = NULL,
  optional = FALSE, cells, t = 0, ...)

\S4method{as.data.frame}{ObsLulcRasterStack}(x, row.names = NULL,
  optional = FALSE, cells, t = 0, ...)
}
\arguments{
\item{x}{an ExpVarRasterList or ObsLulcRasterStack object}

\item{row.names}{NULL or a character vector giving the row.names for the
data.frame. Missing values are not allowed}

\item{optional}{logical. If TRUE, setting row names and converting column
names (to syntactic names: see make.names) is optional}

\item{cells}{index of cells to be extracted, which may be a
\code{SpatialPoints*} object or a numeric vector representing cell numbers
(see \code{raster::\link[raster]{extract}})}

\item{t}{numeric indicating the time under consideration}

\item{\dots}{additional arguments (none)}
}
\value{
A data.frame.
}
\description{
This function extracts data from all raster objects in
\code{\link{ObsLulcRasterStack}} or \code{\link{ExpVarRasterList}} objects
for a specified timestep.
}
\details{
If x is an ObsLulcRasterStack object the raster corresponding to t is first
transformed to a RasterBrick with a boolean layer for each class with
\code{raster::\link[raster]{layerize}}.
}
\examples{
\dontrun{

## Plum Island Ecosystems

## observed maps
obs <- ObsLulcRasterStack(x=pie,
                          pattern="lu",
                          categories=c(1,2,3),
                          labels=c("Forest","Built","Other"),
                          t=c(0,6,14))

## explanatory variables
ef <- ExpVarRasterList(x=pie, pattern="ef")

## separate data into training and testing partitions
part <- partition(x=obs[[1]], size=0.1, spatial=TRUE)
df1 <- as.data.frame(x=obs, cells=part[["all"]], t=0)
df2 <- as.data.frame(x=ef, cells=part[["all"]], t=0)

}
}
\seealso{
\code{\link[base]{as.data.frame}}, \code{\link{ObsLulcRasterStack}},
\code{\link{ExpVarRasterList}}, \code{\link{partition}}
}

