% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fadjpbon}
\alias{fadjpbon}
\title{Adjusted p-values for Bonferroni-based graphical approaches}
\usage{
fadjpbon(w, G, p)
}
\arguments{
\item{w}{The vector of initial weights for elementary hypotheses.}

\item{G}{The initial transition matrix.}

\item{p}{The raw p-values for elementary hypotheses.}
}
\value{
A matrix of adjusted p-values.
}
\description{
Obtains the adjusted p-values for graphical approaches 
using weighted Bonferroni tests.
}
\examples{

pvalues <- matrix(c(0.01,0.005,0.015,0.022, 0.02,0.015,0.010,0.023),
                  nrow=2, ncol=4, byrow=TRUE)
w <- c(0.5,0.5,0,0)
g <- matrix(c(0,0,1,0,0,0,0,1,0,1,0,0,1,0,0,0), 
            nrow=4, ncol=4, byrow=TRUE)
fadjpbon(w, g, pvalues)

}
\references{
Frank Bretz, Willi Maurer, Werner Brannath and Martin Posch. A 
graphical approach to sequentially rejective multiple test 
procedures. Statistics in Medicine. 2009; 28:586-604.
}
