% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_bind.R
\name{l_bind_state_reorder}
\alias{l_bind_state_reorder}
\title{Reorder the state binding evaluation sequence}
\usage{
l_bind_state_reorder(target, ids)
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{ids}{new state binding id evaluation order, this must be a 
rearrangement of the elements returned by the
\code{\link{l_bind_state_ids}} function.}
}
\value{
vector with binding id evaluation order (same as the \code{id} argument)
}
\description{
The order the state bindings defines how they get evaluated 
  once an event matches event patterns of multiple state bindings.
}
\details{
Bindings, callbacks, and binding substitutions are described in detail in
loon's documentation webpage, i.e. run \code{l_help("learn_R_bind")}
}
\seealso{
\code{\link{l_bind_state}}, \code{\link{l_bind_state_ids}},
  \code{\link{l_bind_state_get}}, \code{\link{l_bind_state_delete}}
}
