% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphutils.R
\name{as.loongraph}
\alias{as.loongraph}
\title{Convert a graph object to a loongraph object}
\usage{
as.loongraph(graph)
}
\arguments{
\item{graph}{object of class graph (defined in the graph library)}
}
\value{
graph object of class loongraph
}
\description{
Sometimes it is simpler to work with objects of class loongraph
  than to work with object of class graph.
}
\details{
See
  \url{https://www.bioconductor.org/packages/release/bioc/html/graph.html} for
  more information about the graph R package.

For more information run: \code{l_help("learn_R_display_graph.html.html#graph-utilities")}
}
\examples{
if (requireNamespace("graph", quietly = TRUE)) {
  graph_graph  = graph::randomEGraph(LETTERS[1:15], edges=100)
  loon_graph <- as.loongraph(graph_graph)
}
}
