
context('R and Tcl data conversion')

test_that("nested double", {
    x_star <- 
        c(-0.000864304235090734, 0.292999135695765, 0.949870354364736, 
          0.474503025064823, 0.586862575626621, -0.000864304235090734, 
          -0.586430423509075, -0.474070872947277, -0.949438202247191, -0.29256698357822)
    y_star <-
        c(-1, -0.403630077787381, -0.308556611927398, 0.153846153846154, 
          0.808556611927398, 0.499567847882455, 0.808556611927398, 0.153846153846154, 
          -0.308556611927398, -0.403630077787381)
    x_cross <- 
        c(-0.258931143762604, -0.258931143762604, -0.950374531835206, 
          -0.950374531835206, -0.258931143762604, -0.258931143762604, 0.259651397291847, 
          0.259651397291847, 0.948934024776722, 0.948934024776722, 0.259651397291847, 
          0.259651397291847)
    y_cross <-
        c(-0.950374531835206, -0.258931143762604, -0.258931143762604, 
          0.259651397291847, 0.259651397291847, 0.948934024776722, 0.948934024776722, 
          0.259651397291847, 0.259651397291847, -0.258931143762604, -0.258931143762604, 
          -0.950374531835206)
    x_hexagon <-
        c(0.773552290406223, 0, -0.773552290406223, -0.773552290406223, 
          0, 0.773552290406223)
    y_hexagon <- 
        c(0.446917314894843, 0.894194756554307, 0.446917314894843, -0.447637568424085, 
          -0.892754249495822, -0.447637568424085)
    
    xcoords <- list(x_star, x_cross, x_hexagon)
    ycoords <- list(y_star, y_cross, y_hexagon)
    
    p <- l_plot(1:3, 1:3)
    
    
    gl <- l_glyph_add_polygon(p, x = xcoords, y = ycoords)
    
    p['glyph'] <- gl
    
    expect_equal(lapply(gl['x'], function(x) round(x,5)),
                 lapply(xcoords, function(x) round(x,5)))
    
    expect_equal(lapply(gl['y'], function(x) round(x,5)),
                 lapply(ycoords, function(x) round(x,5)))

    gl['x'] <- lapply(xcoords, function(x)x*1.1)
    
    expect_equal(lapply(gl['x'], function(x) round(x,5)),
                 lapply(xcoords, function(x) round(x*1.1,5)))
    
})
