% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_glyphs.R
\name{l_glyph_add}
\alias{l_glyph_add}
\title{Add non-primitive glyphs to a scatterplot or graph display}
\usage{
l_glyph_add(widget, type, ...)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{type}{object used for method dispatch}

\item{...}{arguments passed on to method}
}
\value{
String with glyph id. Every set of non-primitive glyphs has an id
  (character).
}
\description{
Generic method for adding user-defined glyphs. See details for
  more information about non-primitive and primitive glyphs.
}
\details{
The scatterplot and graph displays both have the n-dimensional state
  \code{'glyph'} that assigns each data point or graph node a glyph (i.e. a 
visual representation). 

Loon distinguishes between primitive and non-primitive glyphs: the primitive 
glyphs are always available for use whereas the non-primitive glyphs need to
be first specified and added to a plot before they can be used.

The primitive glyphs are:

\ifelse{html}{\figure{point_glyph_primitive_types.png}{options: alt="Primitive Glyphs"}}{
\tabular{l}{
  \code{'circle'}, \code{'ocircle'}, \code{'ccircle'}\cr
  \code{'square'}, \code{'osquare'}, \code{'csquare'}\cr
  \code{'triangle'}, \code{'otriangle'}, \code{'ctriangle'}\cr
  \code{'diamond'}, \code{'odiamond'}, \code{'cdiamond'}
}

Note that the letter \code{'o'} stands for outline only, and the letter 
\code{'c'} stands for contrast and adds an outline with the
\code{'foreground'} color (black by default).
}

The non-primitive glyph types and their creator functions are:

\if{html}{\figure{display_plot_glyphs_nonprimitive.png}{options: alt="Non-Primitive Glyphs"}}

\tabular{ll}{
  Type \tab R creator function\cr
  Text \tab \code{\link{l_glyph_add_text}}\cr
  Serialaxes \tab \code{\link{l_glyph_add_serialaxes}}\cr
  Pointranges \tab \code{\link{l_glyph_add_pointrange}}\cr
  Images \tab \code{\link{l_glyph_add_image}}\cr
  Polygon \tab \code{\link{l_glyph_add_polygon}}
}

When adding non-primitive glyphs to a display, the number of glyphs needs to
match the dimension \code{n} of the plot. In other words, a glyph needs to be
defined for each observations. See in the examples.

Currently loon does not support compound glyphs. However, it is possible to
cunstruct an arbitrary glyph using any system and save it as a png and then
re-import them as as image glyphs using \code{\link{l_glyph_add_image}}.

For more information run: \code{l_help("learn_R_display_plot.html#glyphs")}
}
\examples{
# Simple Example with Text Glyphs
p <- with(olive, l_plot(stearic, eicosenoic, color=Region))
g <- l_glyph_add_text(p, text=olive$Area, label="Area")
p['glyph'] <- g

\dontrun{
demo("l_glyphs", package="loon")
}

# create a plot that demonstrates the primitive glyphs and the text glyphs
p <- l_plot(x=1:15, y=rep(0,15), size=10, showLabels=FALSE)
text_glyph <- l_glyph_add_text(p, text=letters [1:15])
p['glyph'] <- c(
    'circle', 'ocircle', 'ccircle',
    'square', 'osquare' , 'csquare',
    'triangle', 'otriangle', 'ctriangle',
    'diamond', 'odiamond', 'cdiamond',
    rep(text_glyph, 3)
)
}
\seealso{
\code{\link{l_glyph_add_text}}, \code{\link{l_make_glyphs}}
}
