% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_currenttags.R
\name{l_currentindex}
\alias{l_currentindex}
\title{Get layer-relative index of the item below the mouse cursor}
\usage{
l_currentindex(widget)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}
}
\value{
index of the visual item's position in the corresponding variable
  dimension of its layer
}
\description{
Checks if there is a visual item below the mouse cursor and if
  there is, it returns the index of the visual item's position in the
  corresponding variable dimension of its layer.
}
\details{
For more details see \code{l_help("learn_R_bind.html#item-bindings")}
}
\examples{
p <- l_plot(iris[,1:2], color=iris$Species)

printEntered <- function(W) {
    cat(paste('Entered point ', l_currentindex(W), '\\n'))
}

printLeave <- function(W) {
    cat(paste('Left point ', l_currentindex(W), '\\n'))
}

l_bind_item(p, tags='model&&point', event='<Enter>',
            callback=function(W) {printEntered(W)})

l_bind_item(p, tags='model&&point', event='<Leave>',
            callback=function(W) {printLeave(W)})
}
\seealso{
\code{\link{l_bind_item}}, \code{\link{l_currenttags}}
}
