% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_cget.R
\name{l_cget}
\alias{l_cget}
\alias{[.loon}
\title{Query a Plot State}
\usage{
l_cget(target, state)
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{state}{state name}
}
\description{
All of loon's displays have plot states. Plot states specify 
  what is displayed, how it is displayed and if and how the plot is linked 
  with other loon plots. Layers, glyphs, navigators and contexts have states 
  too (also refered to as plot states). This function queries a single plot 
  state.
}
\examples{
p <- l_plot(iris, color = iris$Species)
l_cget(p, "color")
p['selected']
}
\seealso{
\code{\link{l_configure}}, \code{\link{l_info_states}},
  \code{\link{l_create_handle}}
}
