% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_estimation.R
\name{dlg}
\alias{dlg}
\title{The locally Gaussian density estimator (LGDE)}
\usage{
dlg(lg_object, grid, level = 0.95, normalization_points = NULL,
  bootstrap = F, B = 500)
}
\arguments{
\item{lg_object}{An object of type \code{lg}, as produced by the
\code{lg_main}-function.}

\item{grid}{A matrix of grid points, where we want to evaluate the density
estimate.}

\item{level}{Specify a level if asymptotic standard deviations and confidence
intervals should be returned.}

\item{normalization_points}{How many grid points for approximating the integral
of the density estimate, to use for normalization?}

\item{bootstrap}{Calculate bootstrapped confidence intervals instead.}

\item{B}{Number of bootstrap replications if using bootstrapped confidence
intervals.}
}
\value{
A list containing the density estimate as well as all the running
  parameters that has been used. The elements are:

  \itemize{
    \item \code{f_est}: The estimated multivariate density.
    \item \code{loc_mean}: The estimated local means if \code{est_method}
           is "5par" or "5par_marginals_fixed", a matrix of zeros if
           \code{est_method} is "1par".
    \item \code{loc_sd}: The estimated local st. deviations if
          \code{est_method} is "5par" or "5par_marginals_fixed", a matrix
          of ones if \code{est_method} is "1par".
    \item \code{loc_cor}: Matrix of estimated local correlations, one
          column for each pair of variables, in the same order as specified
          in the bandwidth object.
    \item \code{x}: The data set.
    \item \code{bw}: The bandwidth object.
    \item \code{transformed_data}: The data transformed to approximate
           marginal standard normality.
    \item \code{normalizing_constants}: The normalizing constants used to
          transform data and grid back and forth to the marginal standard
          normality scale, as seen in eq. (8) of Otneim & Tjøstheim (2017).
    \item \code{grid}: The grid where the estimation was performed, on the
          original scale.
    \item \code{transformed_grid}: The grid where the estimation was
          performed, on the marginal standard normal scale.
    \item \code{normalization_points} Number of grid points used
          to approximate the integral of the density estimate, in order to
          normalize?
    \item \code{normalization_constant} If approximated, the integral of the
          non-normalized density estimate. NA if not normalized.
    \item \code{density_normalized} Logical, indicates whether the final
          density estimate (contained in f_est) has been approximately
          normalized to have unit integral.
    \item \code{loc_cor_sd} Estimated asymptotic standard deviation for the
          local correlations.
    \item \code{loc_cor_lower} Lower confidence limit based on the asymptotic
          standard deviation.
    \item \code{loc_cor_upper} Upper confidence limit based on the asymptotic
          standard deviation.
   }
}
\description{
Estimate a multivariate density function using locally Gaussian
approximations
}
\details{
This function does multivariate density estimation using the locally Gaussian
density estimator (LGDE), that was introduced by Otneim & Tjøstheim (2017).
The function takes as arguments an \code{lg}-object as produced by the main
\code{lg_main}-function (where all the running parameters are specified), and
a grid of points where the density estimate should be estimated.
}
\examples{
   x <- cbind(rnorm(100), rnorm(100), rnorm(100))
   lg_object <- lg_main(x)  # Put all the running parameters in here.
   grid <- cbind(seq(-4, 4, 1), seq(-4, 4, 1), seq(-4, 4, 1))
   density_estimate <- dlg(lg_object, grid = grid)

}
\references{
Otneim, Håkon, and Dag Tjøstheim. "The locally gaussian density estimator for
multivariate data." Statistics and Computing 27, no. 6 (2017): 1595-1616.
}
