% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_estimation.R
\name{clg}
\alias{clg}
\title{The locally Gaussian conditional density estimator}
\usage{
clg(lg_object, grid = NULL, condition = NULL,
  normalization_points = NULL, fixed_grid = NULL)
}
\arguments{
\item{lg_object}{An object of type \code{lg}, as produced by the
\code{lg_main}-function.}

\item{grid}{A matrix of grid points, where we want to evaluate the density
estimate. Number of columns *must* be the same as number of variables in
X1.}

\item{condition}{A vector with conditions for the variables that we condition
upon. Length of this vector *must* be the same as the number of variables
in X2. The function will throw an error of there is any discrepancy in the
dimensions of the \code{grid}, \code{condition} and data set.}

\item{normalization_points}{How many grid points for approximating the integral
of the density estimate, to use for normalization?}

\item{fixed_grid}{Not used presently.}
}
\value{
A list containing the conditional density estimate as well as all the
  running parameters that has been used. The elements are:

  \itemize{
    \item \code{f_est}: The estimated conditional density.
    \item \code{c_mean}: The estimated local conditional means as defined in
         equation (10) of Otneim & Tjøstheim (2017).
    \item \code{c_cov}: The estimated local conditional covariance matrices
          as defined in equation (11) of Otneim & Tjøstheim (2017).
    \item \code{x}: The data set.
    \item \code{bw}: The bandwidth object.
    \item \code{transformed_data}: The data transformed to approximate
          marginal standard normality (if selected).
    \item \code{normalizing_constants}: The normalizing constants used to
          transform data and grid back and forth to the marginal standard
          normality scale, as seen in eq. (8) of Otneim & Tjøstheim (2017)
          (if selected).
    \item \code{grid}: The grid where the estimation was performed, on the
          original scale.
    \item \code{transformed_grid}: The grid where the estimation was
          performed, on the marginal standard normal scale.
    \item \code{normalization_points} Number of grid points used
          to approximate the integral of the density estimate, in order to
          normalize?
    \item \code{normalization_constant} If approximated, the integral of the
          non-normalized density estimate. NA if not normalized.
    \item \code{density_normalized} Logical, indicates whether the final
          density estimate (contained in f_est) has been approximately
          normalized to have unit integral.
 }
}
\description{
Estimate a conditional density function using locally Gaussian
approximations.
}
\details{
This function is the conditional version of the locally Gaussian density
estimator (LGDE), described in Otneim & Tjøstheim (2018). The function takes
as arguments an \code{lg}-object as produced by the main \code{lg_main}- function,
a grid of points where the density estimate should be estimated, and a set of
conditions.

The variables must be sorted before they are supplied to this function. It
will always assume that the free variables come before the conditioning
variables.

Assume that X is a stochastic vector with two components X1 and X2. This
function will thus estimate the conditional density of X1 given a specified
value of X2.
}
\examples{
  # A 3 variate example
  x <- cbind(rnorm(100), rnorm(100), rnorm(100))

  # Generate the lg-object with default settings
  lg_object <- lg_main(x)

  # Estimate the conditional density of X1|X2 = 0, X3 = 1 on a small grid
  cond_dens <- clg(lg_object, grid = matrix(-4:4, ncol = 1), condition = c(0, 1))

}
\references{
Otneim, Håkon, and Dag Tjøstheim. "Conditional density estimation using
  the local Gaussian correlation" Statistics and Computing 28, no. 2 (2018):
  303-321.
}
