% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_aggregate_results.R
\name{opt_aggregate_results}
\alias{opt_aggregate_results}
\title{Function to aggregate trading results from multiple folders and files}
\usage{
opt_aggregate_results(path_data)
}
\arguments{
\item{path_data}{- String, path to the folder containing subfolders}
}
\value{
Dataframe with trading results
}
\description{
PURPOSE: Read multiple '.csv' files stored in different folders
Store results to the intermediate dataframe.
}
\details{
user must provide the path to the files in the folders
all files in subfolders are read and aggregated into one data object.
Data object is sorted in descending order by order close time
}
\examples{

 library(lazytrade)
 library(readr)
 library(dplyr)
 library(magrittr)
 library(lubridate)

 dir <- normalizePath(tempdir(),winslash = "/")

 file.copy(from = system.file("extdata/RES", package = "lazytrade"),
           to = dir, recursive = TRUE)



 DF_RES <- opt_aggregate_results(path_data = file.path(dir, "RES"))


}
