% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_context.R
\name{word_context}
\alias{word_context}
\alias{\%|\%}
\title{Word-context conditional expression}
\usage{
word \%|\% context
}
\arguments{
\item{word}{a character vector. Word or words to include as the variable
part of the conditional expression.}

\item{context}{a character vector of length one. The fixed (or "given") part
of the conditional expression.}
}
\value{
a \code{word_context} class object.
}
\description{
Create word-context conditional expression with the \verb{\%|\%} operator.
}
\details{
The intuitive meaning of the operator \verb{\%|\%} is that of the mathematical
symbol \code{|} (given). This operator is used to create conditional expressions
representing the occurrence of some word after a given context (for instance,
the expression \code{"you" \%|\% "i love"} would represent the occurrence of
the word \code{"you"} after the string "i love"). The purpose of \verb{\%|\%} is to
create objects which can be given as input to probability() (see
\link[kgrams]{probability} for further examples).
}
\examples{
f <- kgram_freqs(much_ado, 2, .tknz_sent = tknz_sent)
m <- language_model(f, "kn", D = 0.5)
probability("leonato" \%|\% "enter", m)

}
\author{
Valerio Gherardi
}
