% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_to_json.R
\name{export_to_json}
\alias{export_to_json}
\alias{export_to_json.justifierStructuredObject}
\alias{print.justifier_json}
\title{Export a justifier specification to JSON}
\usage{
export_to_json(x, file = NULL, wrap_in_html = FALSE)

\method{export_to_json}{justifierStructuredObject}(x, file = NULL, wrap_in_html = FALSE)

\method{print}{justifier_json}(x, ...)
}
\arguments{
\item{x}{The justifier specification.}

\item{file}{Optionally, a file to save the JSON to.}

\item{wrap_in_html}{Whether to wrap the JSON in an HTML element.}

\item{...}{Any additional arguments are ignored.}
}
\value{
If a file is specified to write, to, \code{x} will be returned invisibly
to allow building a pipe chain; if \code{file=NULL}, the resulting JSON
will be returned as a character vector.
}
\description{
Export a justifier specification to JSON
}
\examples{
### Programmatically create a justification with two assertions
### but without sources; flatten it; and show the json
justifier::justify(
  "Icecream will make me feel less fit",
  assertion = c(
    justifier::assert('Icecream is rich in energy'),
    justifier::assert('Consuming high-energy foods makes me feel less fit')
  ),
  weight = -.5
) |>
  justifier::flatten() |>
  justifier::export_to_json();
}
