## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(jellyfisher)

## ----echo=F, message=F--------------------------------------------------------
# Subset the data to keep the compiled vignette a bit smaller
jellyfisher_example_tables <- jellyfisher_example_tables |>
  select_patients(c("EOC69", "EOC677", "EOC495", "EOC809"))

## -----------------------------------------------------------------------------
head(jellyfisher_example_tables$samples, 25)

## -----------------------------------------------------------------------------
head(jellyfisher_example_tables$phylogeny, 25)

## -----------------------------------------------------------------------------
head(jellyfisher_example_tables$compositions, 25)

## -----------------------------------------------------------------------------
head(jellyfisher_example_tables$ranks, 6)

## -----------------------------------------------------------------------------
jellyfisher(jellyfisher_example_tables,
            width = "100%", height = 450)

## -----------------------------------------------------------------------------
jellyfisher(jellyfisher_example_tables,
            options = list(
              sampleHeight = 70,
              sampleTakenGuide = "none",
              tentacleWidth = 3,
              showLegend = FALSE
            ),
            width = "100%", height = 400)

## -----------------------------------------------------------------------------
jellyfisher_example_tables |>
  select_patients("EOC677") |>
  jellyfisher(width = "100%", height = 400)

## -----------------------------------------------------------------------------
jellyfisher_example_tables |>
  select_patients("EOC809") |>
  jellyfisher(width = "100%", height = 600)

## -----------------------------------------------------------------------------
jellyfisher_example_tables |>
  select_patients("EOC809") |>
  set_parents(list("EOC809_r1Bow1_DNA1" = "EOC809_p2Per1_cO_DNA2")) |>
  jellyfisher(width = "100%", height = 600)

## -----------------------------------------------------------------------------
jellyfisher_example_tables |>
  select_patients("EOC495") |>
  jellyfisher(width = "100%", height = 650)

## -----------------------------------------------------------------------------
tables <- jellyfisher_example_tables |>
  select_patients("EOC495")

# Remove existing ranks. The ranks will be assigned automatically based
# on samples' depths in the sample tree.
tables$samples$rank <- NA

# Rank titles should be removed as well because they are no longer valid.
tables$ranks <- NULL

tables |>
  set_parents(list("EOC495_pLNL1_DNA1" = "EOC495_pLNR_DNA1",
                   "EOC495_pLNL2_DNA1" = "EOC495_pLNL1_DNA1")) |>
  jellyfisher(width = "100%", height = 500)

## -----------------------------------------------------------------------------
tables |>
  set_parents(list("EOC495_pLNL1_DNA1" = "EOC495_pLNR_DNA1",
                   "EOC495_pLNL2_DNA1" = "EOC495_pLNL1_DNA1")) |>
  set_ranks(list("EOC495_pLNR_DNA1" = 2,
                 "EOC495_pLNL1_DNA1" = 3,
                 "EOC495_pLNL2_DNA1" = 4),
            default = 1) |>
  jellyfisher(width = "100%", height = 400)

## ----echo=F-------------------------------------------------------------------
rm(tables)

## -----------------------------------------------------------------------------
# Subclone N at the root represents the non-aberrant cells.
# The letter N has no special meaning in Jellyfisher.
non_aberrant <- list(
  samples = data.frame(sample = c("A", "B")),
  compositions = data.frame(
    sample = c("A", "A", "A", "B", "B", "B"),
    subclone = c("N", "1", "2", "N", "1", "2"),
    clonalPrevalence = c(0.2, 0.4, 0.4, 0.3, 0.3, 0.4)
  ),
  phylogeny = data.frame(
    subclone = c("N", "1", "2"),
    parent = c(NA, "N", "1")
  )
)

## -----------------------------------------------------------------------------
non_aberrant |>
  jellyfisher(options = list(
    normalsAtPhylogenyRoot = TRUE
  ),
  width = "100%", height = 350)

## -----------------------------------------------------------------------------
# Change the parent of subclone 2 to N
non_aberrant$phylogeny$parent[non_aberrant$phylogeny$subclone == "2"] <- "N"

non_aberrant |>
  jellyfisher(options = list(
    normalsAtPhylogenyRoot = TRUE
  ),
  width = "100%", height = 350)

## -----------------------------------------------------------------------------
sessionInfo()

