% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adorn_percentages.R
\name{adorn_percentages}
\alias{adorn_percentages}
\title{Convert a data.frame of counts to percentages.}
\usage{
adorn_percentages(dat, denominator = "row", na.rm = TRUE)
}
\arguments{
\item{dat}{a \code{tabyl} or other data.frame with a tabyl-like layout.  If given a list of data.frames, this function will apply itself to each data.frame in the list (designed for 3-way \code{tabyl} lists).}

\item{denominator}{the direction to use for calculating percentages.  One of "row", "col", or "all".}

\item{na.rm}{should missing values (including NaN) be omitted from the calculations?}
}
\value{
Returns a data.frame of percentages, expressed as numeric values between 0 and 1.
}
\description{
This function excludes the first column of the input data.frame, assuming that it contains a descriptive variable.  If the input data.frame is not a \code{tabyl}, it will convert to one in order to preserve the underlying values in the \code{core} attribute.
}
\examples{

mtcars \%>\%
  tabyl(am, cyl) \%>\%
  adorn_percentages("col")

# calculates correctly even with totals column and/or row:
mtcars \%>\%
  tabyl(am, cyl) \%>\%
  adorn_totals("row") \%>\%
  adorn_percentages()
}
