% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_helpers.R
\name{set_ipums_default_collection}
\alias{set_ipums_default_collection}
\title{Set your default IPUMS collection}
\usage{
set_ipums_default_collection(
  collection = NULL,
  save = overwrite,
  overwrite = FALSE,
  unset = FALSE
)
}
\arguments{
\item{collection}{Character string of the collection to set as your
default collection. The collection must currently be supported
by the IPUMS API.

For a list of codes used to refer to each collection, see
\code{\link[=ipums_data_collections]{ipums_data_collections()}}.}

\item{save}{If \code{TRUE}, save the default collection for use in future
sessions by adding it to the \code{.Renviron} file in your home directory.
Defaults to \code{FALSE}, unless \code{overwrite = TRUE}.}

\item{overwrite}{If \code{TRUE}, overwrite any existing value of
\code{IPUMS_DEFAULT_COLLECTION} in the \code{.Renviron} file with the provided
\code{collection}. Defaults to \code{FALSE}.}

\item{unset}{if \code{TRUE}, remove the existing value of
\code{IPUMS_DEFAULT_COLLECTION} from the environment and the \code{.Renviron} file in
your home directory.}
}
\value{
The value of \code{collection}, invisibly.
}
\description{
Set the default IPUMS collection as the value associated with the
\code{IPUMS_DEFAULT_COLLECTION} environment variable. If this environment variable
exists, IPUMS API functions that require a collection specification will use
the value of \code{IPUMS_DEFAULT_COLLECTION}, unless another collection is
indicated.

The default collection can be stored for the duration of your session or
for future sessions. If saved for future sessions, it is added to the
\code{.Renviron} file in your home directory. If you choose to save your key
to \code{.Renviron}, this function will create a backup copy of the file before
modifying.

This function is modeled after the \code{census_api_key()} function
from \href{https://walker-data.com/tidycensus/}{tidycensus}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\examples{
set_ipums_default_collection("nhgis")

\dontrun{
# Extract info will now be retrieved for the default collection:
get_last_extract_info()
get_extract_history()

is_extract_ready(1)
get_extract_info(1)

# Equivalent to:
get_extract_info("nhgis:1")
get_extract_info(c("nhgis", 1))

# Other collections can be specified explicitly
# Doing so does not alter the default collection
is_extract_ready("usa:2")
}

# Remove the variable from the environment and .Renviron, if saved
set_ipums_default_collection(unset = TRUE)
}
\seealso{
\code{\link[=set_ipums_api_key]{set_ipums_api_key()}} to set an API key.
}
