% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_kernel.R
\name{define_kernel}
\alias{define_kernel}
\title{Functions to initialize and define IPM kernels}
\usage{
define_kernel(
  proto_ipm,
  name,
  formula,
  family,
  ...,
  data_list = list(),
  states,
  uses_par_sets = FALSE,
  par_set_indices = list(),
  age_indices = list(),
  evict_cor = FALSE,
  evict_fun = NULL,
  integrate = TRUE
)
}
\arguments{
\item{proto_ipm}{The name of the model.}

\item{name}{The name of the new kernel.}

\item{formula}{A bare expression specifying the form of the kernel.}

\item{family}{The type of kernel. Options are \code{"CC"} for continuous to continuous
transitions, \code{"DC"} for discrete to continuous (e.g. emergence from a seedbank),
\code{"CD"} for continuous to discrete (e.g. entering a seedbank), and \code{"DD"} for
discrete to discrete (e.g. stasis in a seedbank).}

\item{...}{A set of named expressions that correspond
to vital rates in \code{formula}. Parameter set index syntax is supported.}

\item{data_list}{A list of named values that correspond to constants in the formula
and vital rate expressions in \code{...}.}

\item{states}{A list with character vector containing the names of each state
variable used in the kernel.}

\item{uses_par_sets}{A logical indicating whether or not the parameters in the kernel and/or its
underlying vital rates are derived from sets. See the
introduction vignette for this feature for more details
(\code{vignettes(ipmr-introduction', package = 'ipmr')}, and
\code{vignettes( index-notation', package = 'ipmr')}).}

\item{par_set_indices}{A named list with vectors corresponding to the values
the index variable can take. The names should match the suffixes used
in the vital rate expressions.}

\item{age_indices}{If \code{init_ipm(uses_age = TRUE)}, a list with possibly
2 entries: 1. \code{"age"}: the range
of possible ages in the model and, optionally, 2. \code{"max_age"}: the maximum
age individuals in the model can attain. Otherwise, not used.}

\item{evict_cor}{A logical indicating whether an eviction correction should be applied
to the kernel.}

\item{evict_fun}{If \code{evict_cor = TRUE}, then a function that corrects for it.
Currently, only \code{truncated_distributions} and \code{discrete_extrema} are
possible.}

\item{integrate}{For \code{simple_*} models, this controls whether a \code{"d_z"}
is automatically appended to the \code{formula} argument. When \code{TRUE},
this automatically generates \code{formula * d_z}. There may be some cases where
this behavior is not desirable. Set this to \code{FALSE} and specify the correct
form if needed. The default is \code{TRUE}. This argument is ignored for
all \code{general_*} models.}
}
\value{
A \code{proto_ipm}.
}
\description{
Adds a new kernel to the \code{proto_ipm} structure.
}
\details{
Different classes of IPMs may have many or only a few kernels. Each
one requires its own call to \code{define_kernel}, though there are some exceptions,
namely for kernels derived for models derived from parameter sets (e.g. vital
rate models fit across plots and years).

A much more complete overview of how to generate kernels is provided in
\code{vignette("ipmr-introduction", "ipmr")}.
}
