% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_matrix}
\alias{as_matrix}
\title{Convert sparse matrix into dense matrix}
\usage{
as_matrix(x, parallel = FALSE, sparse = FALSE)
}
\arguments{
\item{x}{A matrix.}

\item{parallel}{Logical value, default is \emph{\code{FALSE}}.
Setting to parallelize the computation with \code{\link[RcppParallel]{setThreadOptions}}.}

\item{sparse}{Logical value, default is \emph{\code{FALSE}}, whether to output a sparse matrix.}
}
\description{
Convert sparse matrix into dense matrix
}
\examples{
sparse_matrix <- simulate_sparse_matrix(
  2000,
  2000,
  density = 0.01
)

system.time(as.matrix(sparse_matrix))
system.time(as_matrix(sparse_matrix))
system.time(as_matrix(sparse_matrix, parallel = TRUE))

identical(
  as.matrix(sparse_matrix),
  as_matrix(sparse_matrix)
)

identical(
  as.matrix(sparse_matrix),
  as_matrix(sparse_matrix, parallel = TRUE)
)

identical(
  sparse_matrix,
  as_matrix(as.matrix(sparse_matrix), sparse = TRUE)
)

\dontrun{
network_table_0 <- inferCSN(example_matrix)

network_table_1 <- inferCSN(
  as_matrix(example_matrix, sparse = TRUE)
)
network_table_2 <- inferCSN(
  as(example_matrix, "sparseMatrix")
)

plot_scatter(
  data.frame(
    network_table_0$weight,
    network_table_1$weight
  ),
  legend_position = "none"
)

plot_scatter(
  data.frame(
    network_table_1$weight,
    network_table_2$weight
  ),
  legend_position = "none"
)
}
}
