% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igivenPFn.R
\encoding{UTF-8}
\name{igivenPFn}
\alias{igivenPFn}
\title{Interest rate given Future value, Number of periods, and Present value (Engineering Economics)}
\usage{
igivenPFn(P, F, n)
}
\arguments{
\item{P}{numeric vector that contains the present value(s)}

\item{F}{numeric vector that contains the future value(s)}

\item{n}{numeric vector that contains the period value(s)}
}
\value{
i numeric vector that contains the effective interest rate as a
percent rounded to 2 decimal places
}
\description{
Compute i given F, n, and P
}
\details{
i is expressed as

	\deqn{i = \sqrt[n]{\frac{F}{P}} - 1}

\describe{
\item{\emph{i}}{the "effective interest rate per interest period"}
\item{\emph{F}}{the "future equivalent"}
\item{\emph{P}}{the "present equivalent"}
\item{\emph{n}}{the "number of interest periods"}
}
}
\examples{

# Example for equation 4-6 from the Reference text (page 128)

library(iemisc)

igivenPFn(P = 500, F = 1000, n = 10)



}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 128-129, 142.
}
\author{
Irucka Embry
}
