% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/real.R
\name{icd9IsBillable}
\alias{icd9GetBillable}
\alias{icd9GetBillableDecimal}
\alias{icd9GetBillableShort}
\alias{icd9GetNonBillable}
\alias{icd9GetNonBillableDecimal}
\alias{icd9GetNonBillableShort}
\alias{icd9IsBillable}
\alias{icd9IsBillableDecimal}
\alias{icd9IsBillableShort}
\title{Determine whether codes are billable leaf-nodes}
\usage{
icd9IsBillable(icd9, isShort = icd9GuessIsShort(icd9),
  version = getLatestBillableVersion())

icd9IsBillableShort(icd9Short, version = getLatestBillableVersion())

icd9IsBillableDecimal(icd9Decimal, version = getLatestBillableVersion())

icd9GetBillable(icd9, isShort = icd9GuessIsShort(icd9), invert = FALSE,
  version = getLatestBillableVersion())

icd9GetBillableShort(icd9Short, version = getLatestBillableVersion())

icd9GetBillableDecimal(icd9Decimal, version = getLatestBillableVersion())

icd9GetNonBillableShort(icd9Short, version = getLatestBillableVersion())

icd9GetNonBillableDecimal(icd9Decimal, version = getLatestBillableVersion())

icd9GetNonBillable(icd9, isShort = icd9GuessIsShort(icd9),
  version = getLatestBillableVersion())
}
\arguments{
\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{version}{single character string, default is "32" which is the latest
release from CMS. Currently anything from "23" to "32" is accepted. Not
numeric because there are possible cases with non-numeric names, e.g.
revisions within one year, although none currently implemented.}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{invert}{single logical value, if \code{TRUE}, then the non-billable
codes are returned. For functions with logical result, just negate with
\code{!}. Default is \code{FALSE}.}
}
\value{
logical vector of same length as input
}
\description{
Codes provided are compared to the most recent version of the
  CMS list of billable codes, or another version if specified.
}
\section{Functions}{
\itemize{
\item \code{icd9IsBillableShort}: Are the given short-form codes leaf (billable)
codes in the hierarchy?

\item \code{icd9IsBillableDecimal}: Are the given decimal-form codes leaf (billable)
codes in the hierarchy?

\item \code{icd9GetBillable}: Return only those codes which are leaf (billable)
codes in the hierarchy.

\item \code{icd9GetBillableShort}: Return only those short-form codes which are leaf
(billable) codes in the hierarchy.

\item \code{icd9GetBillableDecimal}: Return only those decimal-form codes which are
leaf (billable) codes in the hierarchy.

\item \code{icd9GetNonBillableShort}: Return only those short-form codes which are not
leaf (billable) codes in the hierarchy. This would include invalid and
heading codes.

\item \code{icd9GetNonBillableDecimal}: Return only those decimal-form codes which are not
leaf (billable) codes in the hierarchy. This would include invalid and
heading codes.

\item \code{icd9GetNonBillable}: Return only those codes which are not leaf
(billable) codes in the hierarchy. This would include invalid and heading
codes. Codes are specified (or guessed) to be all decimal- or short-form.
}}

