% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-ahrq-ccs.R
\name{icd10_parse_ahrq_ccs}
\alias{icd10_parse_ahrq_ccs}
\title{parse AHRQ CCS for mapping - ICD10}
\usage{
icd10_parse_ahrq_ccs(version = "2018.1", save_data = FALSE,
  offline = TRUE)
}
\arguments{
\item{version}{string in format like "2018.1" where 1 is the version number
as shown on the website}

\item{save_data}{logical whether to save the result in the source tree.
Defaults to \code{FALSE}.}

\item{offline}{single logical, if \code{TRUE} then don't pull the file from
internet, only return path and file name if the file already exists in the
raw data directory. This is helpful for testing without using the internet.}
}
\description{
Data is downloaded from AHRQ website. ICD10 codes are continually being
updated so a parameter for \code{version} is provided. This parameter should
mimic those found in
\url{https://www.hcup-us.ahrq.gov/toolssoftware/ccs10/ccs10.jsp#archive}.
These are in the format of \code{YYYY.1}, \code{YYYY.2} etc.
}
\examples{
\dontrun{
  icd:::icd10_parse_ahrq_ccs(version = "2018.1",
      save_data = FALSE, offline = FALSE)
  icd:::icd10_parse_ahrq_ccs(version = "2018.1",
      save_data = FALSE, offline = TRUE)
}
}
\keyword{internal}
\keyword{manip}
