% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ws_download.R
\name{ws_download}
\alias{ws_download}
\title{Download HWSD v2.0 data}
\usage{
ws_download(ws_path = file.path(tempdir(), "ws_db"), verbose = FALSE)
}
\arguments{
\item{ws_path}{the path / directory where to store the HWSD v2.0 database}

\item{verbose}{verbose messaging of downloading and managing the gridded
data file}
}
\value{
current data path
}
\description{
Downloads both the database and gridded HWSD v2.0 data products
to a desired output path for subsetting.
}
\details{
When an existing path is used which is not the temporary directory
an environmental variable WS_PATH can be set by creating an ~/.Renviron file
using usethis::edit_r_environ() and entering the path as:

WS_PATH = "/your/full/path"

This variable will override the default temporary directory if it exists.
This allows the gridded data to be stored elsewhere and be forgotten 
(while using the {hwsdr} package for HWSD v2.0).

Should you delete the gridded file, the environmental variable should be
altered and set again by editting the ~/.Renviron file to a new location.
}
\examples{

\dontrun{
 
 # Download the gridded soil map of
 # HWSD v2.0 to the temporary directory
 ws_download()
 
 # download the same data to a specific
 # directory (which should exist)
 ws_download(
  ws_path = "~/my_path"
 )
 
 # download the same data to a specific
 # directory (which should exist) and
 # update the environmental variable
 ws_download(
 ws_path = "~/my_path",
 verbose = TRUE
 )
}
}
