% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smatrix.R
\name{smatrix}
\alias{smatrix}
\title{Summing matrix for hierarchical or grouped time series}
\usage{
smatrix(xts)
}
\arguments{
\item{xts}{Hierarchical or grouped time series of class \code{gts}.}
}
\value{
A numerical matrix.
}
\description{
This function returns the summing matrix for a hierarchical or grouped time
series, as defined in Hyndman et al. (2011).
}
\examples{

smatrix(htseg1)

}
\references{
Hyndman, R. J., Ahmed, R. A., Athanasopoulos, G., & Shang, H. L.
(2011). Optimal combination forecasts for hierarchical time series.
\emph{Computational Statistics and Data Analysis}, \bold{55}(9), 2579--2589.
\url{http://robjhyndman.com/papers/hierarchical/}
}
\seealso{
\code{\link[hts]{hts}}, \code{\link[hts]{gts}},
\code{\link[hts]{combinef}}
}
\author{
Earo Wang
}
\keyword{ts}
