% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmean-funcs.R
\name{hai_kmeans_mapped_tbl}
\alias{hai_kmeans_mapped_tbl}
\alias{kmeans_mapped_tbl}
\title{K-Means Mapping Function}
\usage{
hai_kmeans_mapped_tbl(.data, .centers = 15)

kmeans_mapped_tbl(.data, .centers = 15)
}
\arguments{
\item{.data}{You must have a tibble in the working environment from the
\code{\link[=hai_kmeans_user_item_tbl]{hai_kmeans_user_item_tbl()}}}

\item{.centers}{How many different centers do you want to try}
}
\value{
A nested tibble
}
\description{
Create a tibble that maps the \code{\link[=hai_kmeans_obj]{hai_kmeans_obj()}} using \code{\link[purrr:map]{purrr::map()}}
to create a nested data.frame/tibble that holds n centers. This tibble will be
used to help create a scree plot.
}
\details{
Takes in a single parameter of .centers. This is used to create the tibble
and map the \code{\link[=hai_kmeans_obj]{hai_kmeans_obj()}} function down the list creating a nested tibble.
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data \%>\%
  filter(ip_op_flag == "I") \%>\%
  filter(payer_grouping != "Medicare B") \%>\%
  filter(payer_grouping != "?") \%>\%
  select(service_line, payer_grouping) \%>\%
  mutate(record = 1) \%>\%
  as_tibble()

ui_tbl <- hai_kmeans_user_item_tbl(
  .data = data_tbl,
  .row_input = service_line,
  .col_input = payer_grouping,
  .record_input = record
)

hai_kmeans_mapped_tbl(ui_tbl)

}
\seealso{
\url{https://en.wikipedia.org/wiki/Scree_plot}

Other Kmeans: 
\code{\link{hai_kmeans_automl_predict}()},
\code{\link{hai_kmeans_automl}()},
\code{\link{hai_kmeans_obj}()},
\code{\link{hai_kmeans_scree_data_tbl}()},
\code{\link{hai_kmeans_scree_plt}()},
\code{\link{hai_kmeans_tidy_tbl}()},
\code{\link{hai_kmeans_user_item_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
