% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{hdd_setkey}
\alias{hdd_setkey}
\title{Sorts HDD objects}
\usage{
hdd_setkey(x, key, newfile, chunkMB = 500, replace = FALSE,
  verbose = 1)
}
\arguments{
\item{x}{A hdd file.}

\item{key}{A character vector of the keys.}

\item{newfile}{Destination of the result, i.e., a destination folder that will receive the HDD data.}

\item{chunkMB}{The size of chunks used to sort the data. Default is 500MB. The bigger this number the faster the sorting is (depends on your memory available though).}

\item{replace}{Default is \code{FALSE}: if the destination folder already contains data, whether to replace it.}

\item{verbose}{Numeric, default is 1. Whether to display information on the advancement of the algorithm. If equal to 0, nothing is displayed.}
}
\description{
This function sets a key to a HDD file. It creates a copy of the HDD file sorted by the key. Note that the sorting process is very time consuming.
}
\details{
This function is provided for convenience reason: it does the job of sorting the data and ensuring consistency across files, but it is very slow since it involves copying several times the entire data set. To be used parsimoniously.
}
\examples{

# Toy example with iris data

# Creating HDD data to be sorted
hdd_path = tempfile() # => folder where the data will be saved
write_hdd(iris, hdd_path)
# Let's add data to it
for(i in 1:10) write_hdd(iris, hdd_path, add = TRUE)

base_hdd = hdd(hdd_path)
summary(base_hdd)

# Sorting by Sepal.Width
hdd_sorted = tempfile()
# we use a very small chunkMB to show how the function works
hdd_setkey(base_hdd, key = "Sepal.Width",
		   newfile = hdd_sorted, chunkMB = 0.010)


base_hdd_sorted = hdd(hdd_sorted)
summary(base_hdd_sorted) # => additional line "Sorted by:"
print(base_hdd_sorted)

# Sort with two keys:
hdd_sorted = tempfile()
# we use a very small chunkMB to show how the function works
hdd_setkey(base_hdd, key = c("Species", "Sepal.Width"),
		   newfile = hdd_sorted, chunkMB = 0.010)


base_hdd_sorted = hdd(hdd_sorted)
summary(base_hdd_sorted)
print(base_hdd_sorted)

}
\seealso{
See \code{\link[hdd]{hdd}}, \code{\link[hdd]{sub-.hdd}} and \code{\link[hdd]{cash-.hdd}} for the extraction and manipulation of out of memory data. For importation of HDD data sets from text files: see \code{\link[hdd]{txt2hdd}}.

See \code{\link[hdd]{hdd_slice}} to apply functions to chunks of data (and create HDD objects) and \code{\link[hdd]{hdd_merge}} to merge large files.

To create/reshape HDD objects from memory or from other HDD objects, see \code{\link[hdd]{write_hdd}}.

To display general information from HDD objects: \code{\link[hdd]{origin}}, \code{\link[hdd]{summary.hdd}}, \code{\link[hdd]{print.hdd}}, \code{\link[hdd]{dim.hdd}} and \code{\link[hdd]{names.hdd}}.
}
\author{
Laurent Berge
}
