% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterModeling_plottingfunctions.R
\name{plot_credible_intervals}
\alias{plot_credible_intervals}
\title{Plot Credible Intervals}
\usage{
plot_credible_intervals(
  model,
  interval_min = 0.025,
  interval_max = 0.975,
  facet = FALSE
)
}
\arguments{
\item{model}{A model created by \code{\link[=fit_model]{fit_model()}}}

\item{interval_min}{The lower bound of the credible interval. It must be greater than zero and less than 1.}

\item{interval_max}{The upper bound of the credible interval. It must be greater than the interval minimum and less than 1.}

\item{facet}{\code{TRUE} uses \code{facet_wrap} to create a subplot for each writer.
\code{FALSE} plots the data on a single plot.}
}
\value{
ggplot plot credible intervals
}
\description{
Plot credible intervals for the model's pi parameters that estimate the true writer
cluster fill counts.
}
\examples{
plot_credible_intervals(model = example_model_1chain)
plot_credible_intervals(model = example_model_1chain, facet = TRUE)

}
