% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{plotLine}
\alias{plotLine}
\title{Plot Line}
\usage{
plotLine(letterList, whichLine, dims)
}
\arguments{
\item{letterList}{Letter list from processHandwriting function}

\item{whichLine}{Single value denoting which line to plot - checked if too big inside function.}

\item{dims}{Dimensions of the original document}
}
\value{
ggplot plot of single line
}
\description{
This function returns a plot of a single line extracted from a document.
It uses the letterList parameter from the processHandwriting function and accepts a single value as whichLetter.
Dims requires the dimensions of the entire document, since this isn't contained in processHandwriting.
}
\examples{
twoSent_document = list()
twoSent_document$image = twoSent
twoSent_document$thin = thinImage(twoSent_document$image)
twoSent_processList = processHandwriting(twoSent_document$thin, dim(twoSent_document$image))

dims = dim(twoSent_document$image)
plotLine(twoSent_processList$letterList, 1, dims)

}
