% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{unsymmetrise.cf}
\alias{unsymmetrise.cf}
\title{Unfold a correlation function which has been symmetrised}
\usage{
unsymmetrise.cf(cf, sym.vec = c(1))
}
\arguments{
\item{cf}{\code{cf} object which has been previously symmetrised}

\item{sym.vec}{Integer vector giving the symmetry properties (see \link{symmetrise.cf})
of the original unsymmetrised correlation function. This should be of
length cf$nrObs}
}
\value{
Returns an object of class \code{cf}, which is the unfolded version
of the input \code{cf} object.
}
\description{
After a symmetric correlation function has been averaged across the central
time slice, it is sometimes useful to explicitly duplicate the resulting
average to span all cf$Time time slices. This function takes a \code{cf} with
cf$Time/2+1 time slices and turns it into one with cf$Time time slices by
reflecting the correlation function along the cf$Time/2 axis.
}
