% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{resampling_is_concatenable}
\alias{resampling_is_concatenable}
\title{Checks whether the resampling of two cf objects is concatenable}
\usage{
resampling_is_concatenable(cf1, cf2)
}
\arguments{
\item{cf1}{\code{cf} object with \code{cf_boot}}

\item{cf2}{\code{cf} object with \code{cf_boot}}
}
\value{
List of named booleans for each of the checked conditions
with elements \code{boot}, \code{boot.R}, \code{boot.l}, \code{sim}, \code{endcorr},
\code{resampling_method}, \code{boot_nrow}, \code{icf} and, optionally
\code{iboot_nrow} (if both \code{cf1} and \code{cf2} contain imaginary parts).
}
\description{
Checks whether the resampling of two cf objects is concatenable
}
\details{
In contrast to \link{resampling_is_compatible}, this function
checks if the resampling samples are concatenable on the
horizontal axis. In addition to checking all meta parameters,
the number of rows in the resampling arrays must be identical
but the number of columns may differ.
}
