% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readutils.R
\name{readnissatextcf}
\alias{readnissatextcf}
\title{reader for Nissa text format correlation functions}
\usage{
readnissatextcf(file_basenames_to_read, smear_combs_to_read, Time,
  combs_to_read, nts = Time, sym.vec = c(1), symmetrise = FALSE)
}
\arguments{
\item{file_basenames_to_read}{Character vector of file names without the
smearing combination suffixes (such as 'll', 'ls', 'sl', 'ss')
which will be added in the reading routine accordign to what was
passed via \code{smear_combs_to_read}. An example would be
'0001/mes_contr_2pts', not the lack of the smearing suffix.}

\item{smear_combs_to_read}{Character vector containing the smearing cominations that are to be read.
These will be attached to the \code{file_basenames_to_read} in the reading routine.}

\item{Time}{Integer, time extent of the lattice.}

\item{combs_to_read}{Data frame containing the indices of the masses and r-paramter combinations to
be read as well as the name of the spin combination.
For a two-point function using the second and third mass (0-indexed),
the (+^dag,+) r-combination and the pseudoscalar-pseudoscalar spin combination
would look as follows:
\tabular{rrrrr}{
m1_idx \tab m2_idx \tab r1_idx \tab r2_idx \tab spin_comb \cr
1      \tab 2      \tab 0      \tab 0      \tab "P5P5"
}}

\item{nts}{Integer, number of time slices to be read from the correlator files.}

\item{sym.vec}{Integer or numeric vector. Specifies whether the correlator at
the given position is symmetric (+1.0) or anti-symmetric (-1.0 )
under time reflection. This is passed to \code{symmetrise.cf}. This
should be of sufficient length to cover all correlators that are
going to be read (one number per row of \code{combs_to_read} and
per entry of \code{smear_combs_to_read})}

\item{symmetrise}{Boolean, specifies whether averaging over backward and forward
correlators should be done after the correlator has been read in.}
}
\value{
Returns an object of class \code{cf}.
}
\description{
reader for Nissa text format correlation functions
}
