% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotutils.R
\name{plot.outputdata}
\alias{plot.outputdata}
\title{Plot Command For Class Ouputdata}
\usage{
\method{plot}{outputdata}(x, skip = 0, ...)
}
\arguments{
\item{x}{object of class \dQuote{outputdata} obtained from a read with
\code{readoutputdata}}

\item{skip}{number of trajectories to be skipped in analysis for plaquette
and \eqn{\exp(-\Delta H)}{exp(-Delta H)}.}

\item{...}{additional arguments passed to the generic plot function.}
}
\value{
list containing the \dQuote{data}, an object of class \dQuote{uwerr}
called \dQuote{plaq.res} containing the statisical analysis for the
plaquette and a second object of type \dQuote{uwerr} called \dQuote{dH.res}
with the statisical analysis for \eqn{\exp(-\Delta }{exp(-Delta H)}\eqn{
H)}{exp(-Delta H)}.

The plotted data is return in form of a \link{list} with named elements \code{data}
containing the input data, plaq.res an object returned by \link{uwerrprimary}
for the plaquette data dn \code{dH.res} an object returned by \link{uwerrprimary}
for \eqn{\Delta H}{Delta H}.
}
\description{
Generic plot routine for class \dQuote{ouputdata}. Currently it plots the
plaquette history and the history of \eqn{\Delta H}{Delta H}
}
\examples{

plaq <- readoutputdata(paste0(system.file(package="hadron"), "/extdata/output.data"))
plaq.plot <- plot(plaq, skip=100)
summary(plaq.plot$plaq.res)

}
\seealso{
\code{\link{readoutputdata}}, \code{\link{uwerr}}
}
\author{
Carsten Urbach, \email{curbach@gmx.de}
}
\keyword{hplot}
\keyword{methods}
