% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_matrixfit.R
\name{new_matrixfit}
\alias{new_matrixfit}
\title{perform a factorising fit of a matrix of correlation functions}
\usage{
new_matrixfit(cf, t1, t2, parlist, sym.vec = rep(1, cf$nrObs),
  neg.vec = rep("cosh", cf$nrObs), useCov = FALSE, model = "single",
  boot.fit = TRUE, fit.method = "optim", autoproceed = FALSE, par.guess,
  every, higher_states = list(val = numeric(0), boot = matrix(nrow = 0, ncol
  = 0), ampl = numeric(0)), ...)
}
\arguments{
\item{cf}{Object of class \code{cf} with \code{cf_meta} and \code{cf_boot}.}

\item{t1}{Integer, start time slice of fit range (inclusive).}

\item{t2}{Integer, end time slie of fit range (inclusive).}

\item{parlist}{Numeric vector, list of parameters for the model function.}

\item{sym.vec}{Integer, numeric or vectors thereof specifying the symmetry
properties of the correlation functions stored in \code{cf}. See
\link{matrixfit} for details.}

\item{neg.vec}{Integer or integer vector of global signs, see
\link{matrixfit} for details.}

\item{useCov}{Boolean, specifies whether a correlated chi^2 fit should be
performed.}

\item{model}{String, specifies the type of model to be assumed for the
correlator. See below for details.}

\item{boot.fit}{Boolean, specifies if the fit should be bootstrapped.}

\item{fit.method}{String, specifies which minimizer should be used. See
\link{matrixfit} for details.}

\item{autoproceed}{Boolean, if TRUE, specifies that if inversion of the
covariance matrix fails, the function should proceed anyway assuming no
correlation (diagonal covariance matrix).}

\item{par.guess}{Numeric vector, initial values for the paramters, should be
of the same length as \code{parlist}.}

\item{every}{Integer, specifies a stride length by which the fit range should
be sparsened, using just \code{every}th time slice in the fit.}

\item{higher_states}{List with elements \code{val} and \code{boot}. Only used in the
\code{n_particles} fit model. The member \code{val} must have the central energy
values for all the states that are to be fitted. The \code{boot} member will be
a matrix that has the various states as columns and the corresponding
bootstrap samples as rows. The length of \code{val} must be the column number of
\code{boot}. The row number of \code{boot} must be the number of samples.}

\item{...}{Further parameters.}
}
\value{
See \link{bootstrap.nlsfit}.
}
\description{
Modernised and extended implementation of \link{matrixfit}
}
\details{
There are different fit models available. The models generally
depend on one or multiple energies \eqn{E} and amplitudes \eqn{p_i} which
for a general matrix are row- and column-amplitudes. The relative sign
factor \eqn{c \in \{-1, 0, +1\}} depends on the chosen symmetry of the
correlator. It is a plus for a “cosh” symmetry and a minus for a “sinh”
symmetry. If the back propagating part is to be neglected (just “exp”
model), it will be zero.

When the back propagating part is not taken into account, then the
\code{single}, \code{shifted} and \code{weighted} model become the same except for changes
in the amplitude.
\itemize{
\item \code{single}: The default model for a single state correlator is
\deqn{\frac{1}{2} p_i p_j (\exp(-p_1 t) \pm c \exp(-p_2 (T-t))) \,.}
\item \code{shifted}: If the correlator has been shifted (using
\link{takeTimeDiff.cf}, then the following model is applicable: \deqn{p_i
  p_j (\exp(-p_1 (t+1/2)) \mp c \exp(-p_1 (T-(t+1/2)))) \,.}
\item \code{weighted}: Works similarly to the \code{shifted} model but includes the
effect of the weight factor from \link{removeTemporal.cf}.
\item \code{pc}: In case only a single principal correlator from a GEVP is to be
fitted this model can be used. It implements \deqn{\exp(-p_1(t-t_0))(p_2 +
  (1-p_2)\exp(-p_3 (t-t_0))} with \eqn{t_0} the reference timesclice of the
GEVP. See \link{bootstrap.gevp} for details.
\item \code{two_amplitudes}: Should there be a single state but different amplitudes
in the forward and backwards part, the following method is applicable.
\deqn{\frac{1}{2} (p_2 \exp(-p_1 t) \pm c p_3 \exp(p_1 t))} This only
works with a single correlator at the moment.
\item \code{single_constant}: Uses the \code{single} model and simply adds \eqn{+ p_3} to
the model such that a constant offset can be fitted. In total the model is
\deqn{\mathrm{single}(p_1, p_2) + p_3 \,.}
\item \code{n_particles}: A sum of \code{single} models with independent energies and
amplitudes: \deqn{\sum_{i = 1}^n \mathrm{single}(p_{2n-1}, p_{2n}) \,.} Use
the \code{higher_states} parameter to restrict the thermal states with priors to
stabilize the fit.
}
}
