% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.diag.plots.R
\name{elliptical.diag.plots}
\alias{elliptical.diag.plots}
\title{Diagnostic Plots for Elliptical Regression Models}
\usage{
elliptical.diag.plots(ellipticalfit, ellipticaldiag = NULL, weighting,
  which, subset = NULL, iden = F, labels = NULL, ret = F, ...)
}
\arguments{
\item{ellipticalfit}{fit object for elliptical regression model.}

\item{ellipticaldiag}{objects containing the diagnostic measures, by default obtained from object.}

\item{weighting}{type of model weighting used.}

\item{which}{an optional numerical that indicates which plot is returned.}

\item{subset}{optional vector specifying a subset of observations to be used in the fitting process.}

\item{iden}{a logical value used to identify observations. if TRUE the observations can be identified in the graphic window.}

\item{labels}{a optinal vector specifying a labels plots.}

\item{ret}{a logical value to indicate funtion returns. If TRUE the return of the function will be to the diagnostic measures used.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
If \code{ret} is true, returns a list of diagnostic arrays (see \code{elliptical.diag} for more details).
}
\description{
This function produces diagnostic measures plots for elliptical regression models.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5),
data=luz)
elliptical.diag.plots(elliptical.fitt, which=3)
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\url{https://doi.org/10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}, \code{\link{elliptical.diag}}
}
\keyword{diagnostic}
\keyword{elliptical}
\keyword{methods}
