% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-utils.R
\name{is_efo_id2}
\alias{is_efo_id2}
\title{Is a string an EFO trait ID in the broad sense?}
\usage{
is_efo_id2(str, convert_NA_to_FALSE = TRUE)
}
\arguments{
\item{str}{A character vector of strings.}

\item{convert_NA_to_FALSE}{Whether to treat \code{NA} as \code{NA}
(\code{convert_NA_to_FALSE = FALSE}) or whether to return \code{FALSE} when
an \code{NA} is found (\code{convert_NA_to_FALSE = TRUE}).}
}
\value{
A logical vector.
}
\description{
This function is more permissible than \code{\link[gwasrapidd]{is_efo_id}}.
This function matches EFO trait IDs against the following regular expression:
\code{^\\\\w+$}. This is very forgiving on the input, any sequence of word
characters are ok. This is useful to match EFO identifiers that do not follow
the regex \code{^EFO_\\\\d\{7\}$}, such as: \code{'GO_0097334'},
\code{'HP_0001268'}, \code{'Orphanet_182098'}, and \code{'NCIT_C74532'}.
}
\keyword{internal}
