% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{gc_get}
\alias{gc_get}
\title{Get a GWAS Catalog resource}
\usage{
gc_get(
  resource_url,
  base_url = gwas_rest_api_base_url,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L
)
}
\arguments{
\item{resource_url}{Endpoint URL. The endpoint is internally appended to the
\code{base_url}. It should start with a forward slash (\code{/}).}

\item{base_url}{The GWAS REST API base URL (one should not need to change its
default value).}

\item{verbose}{Whether to be chatty.}

\item{warnings}{Whether to print warnings.}

\item{page_size}{Page parameter used in the URL endpoint.}
}
\value{
A normalised JSON-list corresponding to either studies, associations,
  variants or traits.
}
\description{
This function gets a GWAS Catalog by URL endpoint. The response must
correspond to one of the four types of entities: studies, associations,
variants or traits.
}
\keyword{internal}
