% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{exibble}
\alias{exibble}
\title{A toy example tibble for testing with gt: exibble}
\format{
A tibble with 8 rows and 9 variables:
\describe{
\item{num}{a numeric column ordered with increasingly larger values}
\item{char}{a character column composed of names of fruits from \code{a} to
\code{h}}
\item{fctr}{a factor column with numbers from 1 to 8, written out}
\item{date, time, datetime}{character columns with dates, times, and
datetimes}
\item{currency}{a numeric column that is useful for testing currency-based
formatting}
\item{row}{a character column in the format \code{row_X} which can be
useful for testing with row captions in a table stub}
\item{group}{a character column with four \code{grp_a} values and four
\code{grp_b} values which can be useful for testing tables that contain
row groups}
}
}
\usage{
exibble
}
\description{
This tibble contains data of a few different classes, which makes it
well-suited for quick experimentation with the functions in this package. It
contains only eight rows with numeric, character, and factor columns. The
last 4 rows contain \code{NA} values in the majority of this tibble's columns (1
missing value per column). The \code{date}, \code{time}, and \code{datetime} columns are
character-based dates/times in the familiar ISO 8601 format. The \code{row} and
\code{group} columns provide for unique rownames and two groups (\code{grp_a} and
\code{grp_b}) for experimenting with the \code{\link[=gt]{gt()}} function's \code{rowname_col} and
\code{groupname_col} arguments.
}
\section{Function ID}{

11-6
}

\examples{
# Here is a glimpse at the data
# available in `exibble`
dplyr::glimpse(exibble)

}
\seealso{
Other Datasets: 
\code{\link{countrypops}},
\code{\link{gtcars}},
\code{\link{pizzaplace}},
\code{\link{sp500}},
\code{\link{sza}}
}
\concept{Datasets}
\keyword{datasets}
