% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/year-scale.R
\name{scale_x_grates_year}
\alias{scale_x_grates_year}
\title{Year scale}
\usage{
scale_x_grates_year(
  ...,
  breaks = ggplot2::waiver(),
  n.breaks = 6L,
  format = NULL
)
}
\arguments{
\item{...}{Not currently used.}

\item{breaks}{A \verb{<grates_isoweek>} vector of the desired breaks.}

\item{n.breaks}{\verb{[integer]}

Approximate number of breaks calculated using \code{scales::breaks_pretty}
(default 6L).

Will only have an effect if \code{breaks = waiver()}.}

\item{format}{Format to use if "Date" scales are required.

If not NULL then the value is used by \code{format.Date()} and can be any input
acceptable by that function.}
}
\value{
A scale for use with ggplot2.
}
\description{
ggplot2 scale for year vector.
}
\examples{
\dontshow{if (requireNamespace("outbreaks") && requireNamespace("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# use simulated linelist data from the outbreaks package
linelist <- outbreaks::ebola_sim_clean$linelist

# calculate yearly cases by date of infection
x <- as_year(linelist$date_of_infection)
(dat <- aggregate(list(cases = x), by = list(year = x), FUN = length))

# by default labels are centred
(year_plot <-
    ggplot2::ggplot(dat, ggplot2::aes(year, cases)) +
    ggplot2::geom_col(width = 1, colour = "white") +
    ggplot2::theme_bw() +
    ggplot2::xlab(""))

# To obtain centred labels you must explicitly set a date format
# in the scale:
year_plot + scale_x_grates_year(format = "\%Y-\%m-\%d")

\dontshow{\}) # examplesIf}
}
