% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layers.R
\name{update_polygons}
\alias{update_polygons}
\title{Update polygons}
\usage{
update_polygons(map, data, id, stroke_colour = NULL, stroke_weight = NULL,
  stroke_opacity = NULL, fill_colour = NULL, fill_opacity = NULL,
  layer_id = NULL)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data.frame containing the new values for the polygons}

\item{id}{string representing the column of \code{data} containing the id
values for the polygons. The id values must be present in the data supplied
to \code{add_polygons} in order for the polygons to be udpated}

\item{stroke_colour}{either a string specifying the column of \code{data}
containing the stroke colour of each circle, or a valid hexadecimal numeric
HTML style to be applied to all the circles}

\item{stroke_weight}{either a string specifying the column of \code{data}
containing the stroke weight of each circle, or a number indicating the width of
pixels in the line to be applied to all the circles}

\item{stroke_opacity}{either a string specifying the column of \code{data}
containing the stroke opacity of each circle, or a value between 0 and 1 that
will be applied to all the circles}

\item{fill_colour}{either a string specifying the column of \code{data}
containing the fill colour of each circle, or a valid hexadecimal numeric
HTML style to be applied to all the cirlces}

\item{fill_opacity}{either a string specifying the column of \code{data}
containing the fill opacity of each circle, or a value between 0 and 1 that
will be applied to all the circles}

\item{layer_id}{single value specifying an id for the layer.}
}
\description{
Updates specific colours and opacities of specified polygons. Designed to be
used in a shiny application.
}
\note{
Any polygons (as specified by the \code{id} argument) that do not exist
in the \code{data} passed into \code{add_polygons()} will not be added to the map.
This function will only update the polygons that currently exist on the map
when the function is called.
}
\examples{
\dontrun{

map_key <- 'your_api_key'

pl_outer <- encode_pl(lat = c(25.774, 18.466,32.321),
                      lon = c(-80.190, -66.118, -64.757))

pl_inner <- encode_pl(lat = c(28.745, 29.570, 27.339),
                      lon = c(-70.579, -67.514, -66.668))

pl_other <- encode_pl(c(21,23,22), c(-50, -49, -51))

## using encoded polylines
df <- data.frame(id = c(1,1,2),
                 colour = c("#00FF00", "#00FF00", "#FFFF00"),
                 polyline = c(pl_outer, pl_inner, pl_other),
                 stringsAsFactors = FALSE)

google_map(key = map_key) \%>\%
  add_polygons(data = df, polyline = 'polyline', id = 'id', fill_colour = 'colour')

df_update <- df[, c("id", "colour")]
df_update$colour <- c("#FFFFFF", "#FFFFFF", "000000")

google_map(key = map_key) \%>\%
  add_polygons(data = df, polyline = 'polyline', id = 'id', fill_colour = 'colour') \%>\%
  update_polygons(data = df_update, id = 'id', fill_colour = 'colour')


df <- aggregate(polyline ~ id + colour, data = df, list)

google_map(key = map_key) \%>\%
  add_polygons(data = df, polyline = 'polyline', fill_colour = 'colour')

google_map(key = map_key) \%>\%
  add_polygons(data = df, polyline = 'polyline', id = 'id', fill_colour = 'colour') \%>\%
  update_polygons(data = df_update, id = 'id', fill_colour = 'colour')


## using coordinates
df <- data.frame(id = c(rep(1, 6), rep(2, 3)),
                 lineId = c(rep(1, 3), rep(2, 3), rep(1, 3)),
                 lat = c(25.774, 18.466, 32.321, 28.745, 29.570, 27.339, 21, 23, 22),
                 lon = c(-80.190, -66.118, -64.757, -70.579, -67.514, -66.668, -50, -49, -51))

google_map(key = map_key) \%>\%
  add_polygons(data = df, lat = 'lat', lon = 'lon', id = 'id', pathId = 'lineId')

google_map(key = map_key) \%>\%
  add_polygons(data = df, lat = 'lat', lon = 'lon', id = 'id', pathId = 'lineId') \%>\%
  update_polygons(data = df_update, id = 'id', fill_colour = 'colour')

}

}

