% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_raster_from_grid.R
\name{gt_make_raster_from_grid}
\alias{gt_make_raster_from_grid}
\title{Make Google Traffic Raster Based on Grid of Coordinates}
\usage{
gt_make_raster_from_grid(
  grid_param_df,
  google_key,
  traffic_color_dist_thresh = 4.6,
  traffic_color_dist_metric = "CIEDE2000",
  webshot_zoom = 1,
  webshot_delay = NULL,
  return_list_of_rasters = FALSE,
  print_progress = TRUE
)
}
\arguments{
\item{grid_param_df}{Grid parameter dataframe produced from \code{\link[=gt_make_grid]{gt_make_grid()}}}

\item{google_key}{Google API key, where the \href{https://developers.google.com/maps/documentation/javascript/overview}{Maps JavaScript API} is enabled. To create a Google API key, follow \href{https://developers.google.com/maps/get-started#create-project}{these instructions}.}

\item{traffic_color_dist_thresh}{Google traffic relies on four main base colors: \verb{#63D668} for no traffic, \verb{#FF974D} for medium traffic, \verb{#F23C32} for high traffic, and \verb{#811F1F} for heavy traffic. Slight variations of these colors can also represent traffic. By default, the base colors and all colors within a 4.6 color distance of each base color are used to define traffic; by default, the \code{CIEDE2000} metric is used to determine color distance. A value of 2.3 is one threshold used to define a "just noticeable distance" (JND) between colors (by default, 2 X JND is used). This parameter changes the color distance from the base colors used to define colors as traffic. For more information, see \href{https://en.wikipedia.org/wiki/Color_difference#CIEDE2000}{here}.}

\item{traffic_color_dist_metric}{See above; this parameter changes the metric used to calculate distances between colors. By default, \code{CIEDE2000} is used; \code{CIE76} and \code{CIE94} can also be used. For more information, see \href{https://en.wikipedia.org/wiki/Color_difference#CIEDE2000}{here}.}

\item{webshot_zoom}{How many pixels should be created relative to height and width values. If \code{height} and \code{width} are set to \code{100} and \code{webshot_zoom} is set to \code{2}, the resulting raster will have dimensions of about \verb{200x200} (default: \code{1}).}

\item{webshot_delay}{How long to wait for Google traffic layer to render. Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{return_list_of_rasters}{Instead of merging traffic rasters produced for each grid together into one large raster, return a list of rasters (default: \code{FALSE})}

\item{print_progress}{Whether to print function progress (default: \code{TRUE})}
}
\value{
Returns a georeferenced raster. Raster pixels can contain the following values: 1 = no traffic; 2 = medium traffic; 3 = high traffic; 4 = heavy traffic.
}
\description{
Make a raster of \href{https://developers.google.com/maps/documentation/javascript/trafficlayer}{Google traffic data}, where each pixel has one of four values
indicating traffic volume (no traffic, light, moderate, and heavy).
}
\examples{
\dontrun{
## Grab polygon of Manhattan
us_sp <- raster::getData('GADM', country='USA', level=2)
ny_sp <- us_sp[us_sp$NAME_2 \%in\% "New York",]

## Make Grid
grid_df <- gt_make_grid(polygon = ny_sp,
                       height   = 2000,
                       width    = 2000,
                       zoom     = 16)

## Make raster from grid                        
r <- gt_make_raster_from_grid(grid_param_df = grid_clean_df,
                              google_key    = "GOOGLE-KEY-HERE")
}

}
\references{
Markus Hilpert, Jenni A. Shearston, Jemaleddin Cole, Steven N. Chillrud, and Micaela E. Martinez. \href{https://arxiv.org/abs/2105.12235}{Acquisition and analysis of crowd-sourced traffic data}. CoRR, abs/2105.12235, 2021.

Pavel Pokorny. \href{https://ieeexplore.ieee.org/abstract/document/8326831}{Determining traffic levels in cities using google maps}. In 2017 Fourth International Conference on Mathematics and Computers in Sciences and in Industry (MCSI), pages 144–147, 2017.
}
