% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery.R
\name{gar_create_package}
\alias{gar_create_package}
\title{Create a Google API package}
\usage{
gar_create_package(api_json, directory, rstudio = TRUE, check = TRUE,
  github = TRUE, format = TRUE, overwrite = TRUE)
}
\arguments{
\item{api_json}{json from \link{gar_discovery_api}}

\item{directory}{Where to build the package}

\item{rstudio}{Passed to \link[devtools]{create}, creates RStudio project file}

\item{check}{Perform a \link[devtools]{check} on the package once done}

\item{github}{If TRUE will upload package to your github}

\item{format}{If TRUE will use \link[formatR]{tidy_eval} on content}

\item{overwrite}{Whether to overwrite an existing directory if it exists}
}
\value{
If check is TRUE, the results of the CRAN check, else FALSE
}
\description{
Create a Google API package
}
\details{
For github upload to work you need to have your github PAT setup. See \link[devtools]{use_github}.

Uses devtools' \link[devtools]{create} to create a package structure then 
  \link{gar_create_api_skeleton} and \link{gar_create_api_objects} to create 
  starting files for a Google API package.
}
\seealso{
\url{https://developers.google.com/discovery/v1/reference/apis/list}

A Github repository with \href{154 R packages}{https://github.com/MarkEdmondson1234/autoGoogleAPI} generated by this function.

Other Google Discovery API functions: \code{\link{gar_create_api_objects}},
  \code{\link{gar_create_api_skeleton}},
  \code{\link{gar_discovery_apis_list}},
  \code{\link{gar_discovery_api}}
}
