% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rank_models}
\alias{rank_models}
\title{Find the Rank Models result}
\usage{
rank_models(data, model_str, full_model, alpha, compute_v, model_type, K, H, G,
  robust, eff, bs_optimism)
}
\arguments{
\item{data}{A \code{vec} of data.}

\item{model_str}{A \code{vector<vector<string>>} that gives a list of models to test.}

\item{full_model}{A \code{vector<string>} that contains the largest / full model.}

\item{alpha}{A \code{double} that indicates the alpha level for CIs.}

\item{compute_v}{A \code{string} indicating the type of V matrix to generate}

\item{model_type}{A \code{string} that describes the model generation / transformation: 'ssm' or 'imu'}

\item{K}{A \code{int} that controls how many times the GMWM is run.}

\item{H}{A \code{int} that controls how many bootstraps occur.}

\item{G}{A \code{int} that controls how many guesses occur.}

\item{robust}{A \code{bool} that indicates whether to use classical or robust wavelet variance.}

\item{eff}{A \code{double} that indicates the efficiency to use.}

\item{bs_optimism}{A \code{bool} that indicates whether the model selection score should be calculated with bootstrap or asymptotics.}
}
\value{
A \code{field<field<field<mat>>>} that contains the model score matrix and the best GMWM model object.
}
\description{
Provides the core material to create an S3 object for rank.models
}
\keyword{internal}

