% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{AR1}
\alias{AR1}
\title{Create an Autoregressive 1 [AR(1)] Process}
\usage{
AR1(phi = NULL, sigma2 = 1)
}
\arguments{
\item{phi}{A \code{double} value for the \eqn{\phi}{phi} of an AR1 process.}

\item{sigma2}{A \code{double} value for the variance, \eqn{\sigma ^2}{sigma^2}, of a WN process.}
}
\value{
An S3 object with called ts.model with the following structure:
\itemize{
 \item{process.desc}{Used in summary: "AR1","SIGMA2"}
 \item{theta}{\eqn{\phi}{phi}, \eqn{\sigma^2}{sigma^2}}
 \item{plength}{Number of Parameters}
 \item{desc}{"AR1"}
 \item{obj.desc}{Depth of Parameters e.g. list(1,1)}
 \item{starting}{Guess Starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Setups the necessary backend for the AR1 process.
}
\examples{
AR1()
AR1(phi=.32, sigma=1.3)
}
\author{
JJB
}

